package com.agilex.healthcare.veteranappointment.testutility;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.veteranappointment.clientapi.MobileHealthClientTestVersion;

import java.net.URI;
import java.util.UUID;

public class TestHelper {
    private static MobileHealthClientTestVersion client = createMobileHealthClient();

	public static MobileHealthClientTestVersion createMobileHealthClient() {
		MobileHealthClientTestVersion mobileHealthClient = new MobileHealthClientTestVersion();
		return mobileHealthClient;
	}

	public static Patient getTestPatientViaDirectRetrieve() {
		Patient searchResultPatient = PatientLoader.loadTestPatient();
		Patient patient = client.getPatientResourceClient().getPatient(searchResultPatient);
		return patient;
	}

        public static Patient getProviderTestPatientViaDirectRetrieve() {
            Patient searchResultPatient = PatientLoader.loadProviderTestPatient();
            Patient patient = client.getPatientResourceClient().getPatient(searchResultPatient);
            return patient;
        }

	public static Patients getTestPatientSearchResults() {
		String lastname = IntegrationTestConfiguration.getTestPatient().getLastName();
		String firstname = IntegrationTestConfiguration.getTestPatient().getFirstName();
		Patient prototype = new Patient();
		prototype.setLastName(lastname);
		prototype.setFirstName(firstname);

		Patients patients = client.getPatientResourceClient().patientSearch(prototype);

		return patients;
	}

	/*public static com.agilex.healthcare.mobilehealthplatform.domain.Document getTestDocument() {
		Patient patient = PatientLoader.loadTestPatient();
		Documents documents = client.getPatientResourceClient().getPatientDocuments(patient);
		com.agilex.healthcare.mobilehealthplatform.domain.Document document = documents.get(0);
		return document;
	}*/

	public static boolean beginsWith(String value, String compareTo) {
		int length = compareTo.length();
		String beginning = value.substring(0, length);
		return beginning.toLowerCase().contentEquals(compareTo.toLowerCase());
	}

	public static PatientIdentifier generateRandomPatientIdentifierInMockAssigningAuthority() {
		return generateRandomPatientIdentifier("EDIPI");
	}

	public static PatientIdentifier generateRandomPatientIdentifier(String assigningAuthority) {
		return new PatientIdentifier(assigningAuthority, UUID.randomUUID().toString());
	}

	public static URI getPatientDataUri(PatientIdentifier patientIdentifier, String linkTitle, String userName) {
		Patient patient = PatientLoader.loadPatient(patientIdentifier, userName);
		return patient.getLink().getUriByTitle(linkTitle);
	}
}
